/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.BlueMSXLauncherDatabasesImporterPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.WindowUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportBlueMSXLauncherDatabasesWindow
extends JDialog
implements ActionListener {
    private final BlueMSXLauncherDatabasesImporterPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final Set<String> machines;
    private JTextField blueMSXLauncherDirectoryTextField;
    private JButton blueMSXLauncherDirectoryButton;
    private JList<Object> availableDatabasesList;
    private DefaultListModel<Object> availableDatabasesListModel;
    private JList<Object> selectedDatabasesList;
    private DefaultListModel<Object> selectedDatabasesListModel;
    private JButton rightArrowButton;
    private JButton leftArrowButton;
    private JComboBox<String> machinesComboBox;
    private JButton okButton;
    private JButton cancelButton;
    private final Dimension databaseListDimension = new Dimension(180, 150);

    public ImportBlueMSXLauncherDatabasesWindow(BlueMSXLauncherDatabasesImporterPresenter presenter, Language language, boolean rightToLeft, Set<String> machines) {
        this.presenter = presenter;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.machines = machines;
    }

    public void displayScreen() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("IMPORT_BLUEMSXLAUNCHER_DATABASES"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel launcherDirectoryPane = new JPanel();
        launcherDirectoryPane.setBorder(BorderFactory.createTitledBorder("blueMSX Launcher"));
        JLabel bmlDirectory = new JLabel(this.messages.get("DIRECTORY"));
        launcherDirectoryPane.add(bmlDirectory);
        this.blueMSXLauncherDirectoryTextField = new JTextField(25);
        this.blueMSXLauncherDirectoryTextField.setEditable(false);
        launcherDirectoryPane.add(this.blueMSXLauncherDirectoryTextField);
        this.blueMSXLauncherDirectoryButton = new JButton(Icons.FOLDER.getImageIcon());
        this.blueMSXLauncherDirectoryButton.setPreferredSize(WindowUtils.iconButtonDimension);
        this.blueMSXLauncherDirectoryButton.addActionListener(this);
        this.blueMSXLauncherDirectoryButton.setToolTipText(this.messages.get("BROWSE"));
        launcherDirectoryPane.add(this.blueMSXLauncherDirectoryButton);
        contentPane.add(launcherDirectoryPane);
        JPanel databasesSelectionPane = new JPanel();
        databasesSelectionPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("DATABASES")));
        JPanel availableDatabasesPane = new JPanel();
        availableDatabasesPane.setLayout(new BoxLayout(availableDatabasesPane, 1));
        JLabel availableLabel = new JLabel(this.messages.get("AVAILABLE"));
        availableDatabasesPane.add(availableLabel);
        this.availableDatabasesListModel = new DefaultListModel();
        this.availableDatabasesList = new JList<Object>(this.availableDatabasesListModel);
        ListSelectionListener availableDatabasesListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] selection;
                if (!listSelectionEvent.getValueIsAdjusting() && (selection = ImportBlueMSXLauncherDatabasesWindow.this.availableDatabasesList.getSelectedIndices()).length == 1) {
                    ImportBlueMSXLauncherDatabasesWindow.this.leftArrowButton.setEnabled(false);
                    ImportBlueMSXLauncherDatabasesWindow.this.rightArrowButton.setEnabled(true);
                    ImportBlueMSXLauncherDatabasesWindow.this.selectedDatabasesList.clearSelection();
                    ImportBlueMSXLauncherDatabasesWindow.this.availableDatabasesList.setSelectedValue(ImportBlueMSXLauncherDatabasesWindow.this.availableDatabasesListModel.getElementAt(selection[0]), false);
                }
            }
        };
        this.availableDatabasesList.addListSelectionListener(availableDatabasesListListener);
        JScrollPane availableDatabasesScrollBar = new JScrollPane(this.availableDatabasesList);
        availableDatabasesScrollBar.setPreferredSize(this.databaseListDimension);
        availableDatabasesPane.add(availableDatabasesScrollBar);
        databasesSelectionPane.add(availableDatabasesPane);
        JPanel arrowsPane = new JPanel();
        arrowsPane.setLayout(new BoxLayout(arrowsPane, 1));
        this.rightArrowButton = new JButton();
        this.rightArrowButton.addActionListener(this);
        this.rightArrowButton.setPreferredSize(WindowUtils.iconButtonDimension);
        this.rightArrowButton.setEnabled(false);
        arrowsPane.add(this.rightArrowButton);
        this.leftArrowButton = new JButton();
        this.leftArrowButton.addActionListener(this);
        this.leftArrowButton.setPreferredSize(WindowUtils.iconButtonDimension);
        this.leftArrowButton.setEnabled(false);
        arrowsPane.add(this.leftArrowButton);
        databasesSelectionPane.add(arrowsPane);
        JPanel selectedDatabasesPane = new JPanel();
        selectedDatabasesPane.setLayout(new BoxLayout(selectedDatabasesPane, 1));
        JLabel selectedLabel = new JLabel(this.messages.get("SELECTED"));
        selectedDatabasesPane.add(selectedLabel);
        this.selectedDatabasesListModel = new DefaultListModel();
        this.selectedDatabasesList = new JList<Object>(this.selectedDatabasesListModel);
        ListSelectionListener selectedDatabasesListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] selection;
                if (!listSelectionEvent.getValueIsAdjusting() && (selection = ImportBlueMSXLauncherDatabasesWindow.this.selectedDatabasesList.getSelectedIndices()).length == 1) {
                    ImportBlueMSXLauncherDatabasesWindow.this.rightArrowButton.setEnabled(false);
                    ImportBlueMSXLauncherDatabasesWindow.this.leftArrowButton.setEnabled(true);
                    ImportBlueMSXLauncherDatabasesWindow.this.availableDatabasesList.clearSelection();
                    ImportBlueMSXLauncherDatabasesWindow.this.selectedDatabasesList.setSelectedValue(ImportBlueMSXLauncherDatabasesWindow.this.selectedDatabasesListModel.getElementAt(selection[0]), false);
                }
            }
        };
        this.selectedDatabasesList.addListSelectionListener(selectedDatabasesListListener);
        JScrollPane selectedDatabasesScrollBar = new JScrollPane(this.selectedDatabasesList);
        selectedDatabasesScrollBar.setPreferredSize(this.databaseListDimension);
        selectedDatabasesPane.add(selectedDatabasesScrollBar);
        databasesSelectionPane.add(selectedDatabasesPane);
        contentPane.add(databasesSelectionPane);
        JPanel machinesPane = new JPanel();
        machinesPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("MACHINE")));
        JLabel machinesLabel = new JLabel(this.messages.get("MACHINE"));
        machinesPane.add(machinesLabel);
        this.machinesComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        machinesPane.add(this.machinesComboBox);
        contentPane.add(machinesPane);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.okButton.setEnabled(false);
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.cancelButton);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            launcherDirectoryPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            launcherDirectoryPane.setLayout(new FlowLayout(2, 5, 5));
            databasesSelectionPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            databasesSelectionPane.setLayout(new FlowLayout(2, 5, 5));
            this.rightArrowButton.setIcon(Icons.LEFT_ARROW.getImageIcon());
            this.leftArrowButton.setIcon(Icons.RIGHT_ARROW.getImageIcon());
            machinesPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            machinesPane.setLayout(new FlowLayout(2, 5, 5));
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            launcherDirectoryPane.setLayout(new FlowLayout(0, 5, 5));
            databasesSelectionPane.setLayout(new FlowLayout(0, 5, 5));
            this.leftArrowButton.setIcon(Icons.LEFT_ARROW.getImageIcon());
            this.rightArrowButton.setIcon(Icons.RIGHT_ARROW.getImageIcon());
            machinesPane.setLayout(new FlowLayout(0, 5, 5));
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.blueMSXLauncherDirectoryButton) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.blueMSXLauncherDirectoryTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                this.populateAvailableDatabasesList(chooser.getSelectedFile());
            }
        } else if (source == this.rightArrowButton) {
            this.moveFromOneListToAnother(this.availableDatabasesList, this.selectedDatabasesList);
            this.okButton.setEnabled(true);
        } else if (source == this.leftArrowButton) {
            this.moveFromOneListToAnother(this.selectedDatabasesList, this.availableDatabasesList);
            if (this.selectedDatabasesListModel.size() == 0) {
                this.okButton.setEnabled(false);
            }
        } else if (source == this.okButton) {
            this.processImportRequest();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void moveFromOneListToAnother(JList<Object> source, JList<Object> target) {
        int[] selections = source.getSelectedIndices();
        DefaultListModel sourceModel = (DefaultListModel)source.getModel();
        DefaultListModel targetModel = (DefaultListModel)target.getModel();
        for (int index = selections.length - 1; index >= 0; --index) {
            targetModel.addElement(sourceModel.getElementAt(selections[index]));
            sourceModel.remove(selections[index]);
        }
    }

    private void populateAvailableDatabasesList(File selectedDirectory) {
        Set<String> databases = this.presenter.onGetDatabasesInDirectory(selectedDirectory);
        this.availableDatabasesListModel.clear();
        this.selectedDatabasesListModel.clear();
        this.rightArrowButton.setEnabled(false);
        this.leftArrowButton.setEnabled(false);
        this.okButton.setEnabled(false);
        for (String database : databases) {
            this.availableDatabasesListModel.addElement(database);
        }
    }

    private void processImportRequest() {
        int selectedSize = this.selectedDatabasesListModel.getSize();
        String[] databaseNames = new String[selectedSize];
        for (int ix = 0; ix < selectedSize; ++ix) {
            databaseNames[ix] = (String)this.selectedDatabasesListModel.getElementAt(ix);
        }
        try {
            int totalImported = this.presenter.onRequestImportBlueMSXLauncherDatabasesAction(this.blueMSXLauncherDirectoryTextField.getText(), databaseNames, (String)this.machinesComboBox.getSelectedItem());
            this.dispose();
            MessageBoxUtil.showInformationMessageBox(this.mainWindow, this.messages.get("TOTAL_IMPORTED_DATABASES") + ": " + totalImported, this.messages, this.rightToLeft);
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
        }
    }
}

